% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predicates.R
\name{is_wholenumber}
\alias{is_wholenumber}
\alias{is_scalar_wholenumber}
\title{Test whether x is a whole number}
\usage{
is_wholenumber(x, tol = .Machine$double.eps^0.5)

is_scalar_wholenumber(x, check_numeric = TRUE, ...)
}
\arguments{
\item{x}{Object to be tested}

\item{tol}{Tolerance}

\item{check_numeric}{Whether to check whether \code{x} is a numeric}

\item{...}{Arguments to pass to \code{is_wholenumber()}}
}
\value{
Logical
}
\description{
\itemize{
\item \code{is_wholenumber()} uses \code{\link[base:Round]{base::round()}} to test whether \code{x} is a whole number,
it will therefore issue an error if \code{x} is not of mode numeric.
If used in \code{\link[base:stopifnot]{base::stopifnot()}} for example, this won't be a problem but it may be in conditionals.
\item \code{is_scalar_wholenumber()} comes with the additional argument \code{check_numeric}
to check whether \code{x} is a numeric before checking it is a whole number.
}
}
\examples{
is_wholenumber(1) # TRUE
is_wholenumber(1.0) # TRUE
is_wholenumber(1.1) # FALSE
is_scalar_wholenumber(1) # TRUE
is_scalar_wholenumber(c(1, 2)) # FALSE
}
