% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/Plotting_with_ggplot.R
\name{plot_errors}
\alias{plot_errors}
\title{A function for plotting functions of errors}
\usage{
plot_errors(PRED, OBS, type = "HISTO_QUA", np = 200)
}
\arguments{
\item{PRED}{a \code{MatH} object with one column, the predicted data}

\item{OBS}{a \code{MatH} object with one column, the observed data}

\item{type}{a string. "HISTO_QUA" (default), if ones want to compare histograms quantile differences\cr
"HISTO_DEN", if ones want to show the histogram densities differences;\cr
"DENS_KDE" if ones want to show the differences between approximated densities (using KDE);\cr}

\item{np}{number of points considered for density  or quantile computation (default=200).}
}
\value{
A plot with functions of differences between observed and predicted histograms, and a
Root Mean Squared value computing by using the L2 Wasserstein distance.
}
\description{
This function allows the representation of the difference between observed histograms and
the respective predicted ones. It can
be used as a tool for interpreting preditive methods (for exampe, the regression of histogrma data)
}
\examples{
## do a regression
pars=WH.regression.two.components(BLOOD,Yvar = 1,Xvars = c(2:3))
## predict data
PRED=WH.regression.two.components.predict(data = BLOOD[,2:3],parameters = pars)
## define observed data
OBS=BLOOD[,1]
plot_errors(PRED,OBS,"HISTO_QUA")
plot_errors(PRED,OBS,"HISTO_DEN")
plot_errors(PRED,OBS,"DENS_KDE")
}

