% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DHRP_Portfolio.R
\name{DHRP_Portfolio}
\alias{DHRP_Portfolio}
\title{Constrained Hierarchical Risk Parity}
\usage{
DHRP_Portfolio(covar, graph = FALSE, tau = 1, UB = NULL, LB = NULL)
}
\arguments{
\item{covar}{Covariance matrix of returns. The covariance matrix will be transformed into correlation matrix and then into a distance matrix.}

\item{graph}{To plot de dendrogram set this value to TRUE. By default this value is equal to FALSE.}

\item{tau}{Parameter to evaluate asset similarity at the cluster edges. Default value is 1.}

\item{UB}{Upper bound for weights. By default this value is equal to NULL}

\item{LB}{Lower bound for weights. By default this value is equal to NULL}
}
\value{
portfolio weights
}
\description{
Performs the Constrained Hierarchical Risk Parity portfolio strategy proposed  by Pfitzinger and Katzke (2019).
}
\examples{
covar <- cov(mldp_returns)
DHRP_Portfolio(covar)
}
\references{
Pfitzinger, J., and Katzke, N. A constrained hierarchical risk parity algorithm with cluster-based capital allocation (2019). Working Paper.
}
\seealso{
\code{HCAA_Portfolio}, \code{HRP_Portfolio} and \code{HERC_Portfolio}
}
\author{
Carlos Trucios and Moon Jun Kwon
}
\keyword{DHRP}
