% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ind_long_lat.R
\name{ind_long_lat}
\alias{ind_long_lat}
\title{Return or the index in ncdf object from lat/longitude or inverse}
\usage{
ind_long_lat(ncdf = stop("The ncdf data must be supplied"), long = NULL,
  lat = NULL, indice.long = NULL, indice.lat = NULL, name.lon = "lon",
  name.lat = "lat")
}
\arguments{
\item{ncdf}{An object read from package ncdf4, ncdf or RNetCDF}

\item{long}{Longitude in decimal format}

\item{lat}{Latitude in decimal format}

\item{indice.long}{Index of longitude}

\item{indice.lat}{Index of latitude}

\item{name.lon}{Name of argument for longitude, default is lon}

\item{name.lat}{Name of argument for latitude, default is lat}
}
\value{
Or the index in ncdf object from lat/longitude or inverse
}
\description{
Return or the index in ncdf object from lat/longitude or reverse.
}
\details{
ind_long_lat is used to manage ncdf information
}
\examples{
\dontrun{
url <- "ftp://ftp.cdc.noaa.gov/Datasets/noaa.oisst.v2.highres/"
url <- paste0(url, "sst.day.mean.2012.v2.nc")
dest <- paste(Sys.getenv("HOME"), "/sst.day.mean.2012.v2.nc", sep="")
download.file(url, dest)
library("ncdf4")
dta2012 <- nc_open(dest)
indices <- ind_long_lat(ncdf=dta2012, lat=5.89, long=-20.56)
coordinates <- ind_long_lat(ncdf=dta2012, indice.lat=20, indice.long=30)
# library("RNetCDF")
# dta2012 <- open.nc(dest)
# indices <- ind_long_lat(ncdf=dta2012, lat=5.89, long=-20.56)
# coordinates <- ind_long_lat(ncdf=dta2012, indice.lat=20, indice.long=30)
# ncdf library is depreciated in CRAN
# library("ncdf")
# dta2012 <- open.ncdf(dest)
# indices <- ind_long_lat(ncdf=dta2012, lat=5.89, long=-20.56)
# coordinates <- ind_long_lat(ncdf=dta2012, indice.lat=20, indice.long=30)
}
}
\author{
Marc Girondot
}
