% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rHeckman.R
\name{rHeckman}
\alias{rHeckman}
\title{Data generation from the Heckman Selection model (Normal or Student-t)}
\usage{
rHeckman(x, w, beta, gamma, sigma2, rho, nu = 4, family = "T")
}
\arguments{
\item{x}{A covariate matrix for the response y.}

\item{w}{A covariate matrix for the missing indicator cc.}

\item{beta}{Values for the beta vector.}

\item{gamma}{Values for the gamma vector.}

\item{sigma2}{Value for the variance.}

\item{rho}{Value for the dependence between the response and missing value.}

\item{nu}{Value for the degrees of freedom.}

\item{family}{The family to be used (Normal or T).}
}
\value{
Return an object with the response (y) and missing values (cc).
}
\description{
`rHeckman()` generates a random sample from the Heckman selection model (Normal or Student-t).
}
\examples{
\donttest{
n <- 100
rho <- .6
cens <- 0.25
nu <- 4
set.seed(20200527)
w <- cbind(1,runif(n,-1,1),rnorm(n))
x <- cbind(w[,1:2])

family <- "T"
c <- qt(cens, df=nu)

sigma2 <- 1
beta <- c(1,0.5)
gamma<- c(1,0.3,-.5)
gamma[1] <- -c*sqrt(sigma2)

data <- rHeckman(x,w,beta,gamma,sigma2,rho,nu,family=family)
}
}
