% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_ScalePar.R
\name{ScalePar}
\alias{ScalePar}
\title{Scale 'par.txt' files to different model time step}
\usage{
ScalePar(x, sfac = 1/24, digits = 3, verbose = TRUE, print.par = FALSE)
}
\arguments{
\item{x}{List containing HYPE parameters. Typically imported with \code{\link[=ReadPar]{ReadPar()}}.}

\item{sfac}{Numeric, scale factor. Defaults to scaling from daily to hourly time steps.}

\item{digits}{Integer, number of significant digits \emph{in SLC class columns} to export. See \code{\link[=signif]{signif()}}.}

\item{verbose}{Logical, if \code{TRUE}, then information will be printed.}

\item{print.par}{Logical, print known time-scale dependent parameters instead of scaling a par list.}
}
\value{
A \code{\link[=list]{list()}} object as supplied in \code{x}, with parameters re-scaled parameters, or nothing if \code{print.par = TRUE}.
}
\description{
\code{ScalePar} scales time step-dependent parameters in an imported
\href{http://www.smhi.net/hype/wiki/doku.php?id=start:hype_file_reference:par.txt}{HYPE 'par.txt'} parameter file to a
new target time step.
}
\details{
\code{ScalePar} simply applies a user-chosen scaling factor \code{sfac} to all time scale-dependent parameters
in a HYPE parameter list. Parameters are matched against an inbuilt set of parameter names.
\emph{\href{https://github.com/rcapell/HYPEtools/issues}{Please notify us} if you find parameters missing.}
}
\examples{
# Import daily HYPE parameter file
hpar <- ReadPar(filename = system.file("demo_model", "par.txt", package = "HYPEtools"))
# Scale to hourly time steps
ScalePar(x = hpar)
# Print all time scale-dependent parameters known to the function
ScalePar(print.par = TRUE)

}
