% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functioncollection_export.R
\name{WriteXobs}
\alias{WriteXobs}
\title{Write an 'Xobs.txt' File}
\usage{
WriteXobs(
  x,
  filename,
  append = FALSE,
  comment = NULL,
  variable = NULL,
  subid = NULL,
  last.date = NULL,
  timestep = "d"
)
}
\arguments{
\item{x}{A data frame, e.g. an object originally imported with \code{\link{ReadXobs}}. Date-time information in the first
column and measured values in the remaining columns. Column names are ignored on export, but if attributes \code{comment},
\code{variable}, and \code{subid} are available, these can be exported as Xobs headers (see also arguments of the same names
below).}

\item{filename}{A character string naming a file to write to. Windows users: Note that
Paths are separated by '/', not '\\'.}

\item{append}{Logical. If \code{TRUE}, \code{x} will be appended to file \code{filename}. File must exist and
have an identical column structure as \code{x}. If \code{FALSE}, existing file in \code{filename} will be overwritten!}

\item{comment}{A character string to be exported as first row comment in the Xobs file. If provided, it takes precedence over
a \code{comment} attribute of \code{x}. Comments are only exported if \code{append} is \code{FALSE}.}

\item{variable}{A character vector to be exported as second row in the Xobs file. Must contain the same number of
variables as \code{x}. If omitted or \code{NULL}, an attribute \code{variable} in \code{x} is mandatory.
Will take precedence over a \code{variable} attribute of \code{x}. If \code{append} is \code{TRUE} the values are
used to test for consistency between export object and the existing file.}

\item{subid}{Third row in Xobs, containing SUBIDs (integer). Behaviour otherwise as argument \code{variable}.}

\item{last.date}{Optional date-time of last observation in existing Xobs file as text string. Only relevant with \code{append = TRUE}.
Formatting depending on time step, e.g. \code{'2000-01-01'} (day) or \code{'2000-01-01 00:00'} (hour). Will be automatically read
from file per default, but can be provided to reduce execution time when appending to large files.}

\item{timestep}{Character string, either "day" or "hour", giving the time step between observations. Can be
abbreviated.}
}
\value{
No return value, called for export to text files.
}
\description{
\code{WriteXobs} writes or appends an observation data set to an Xobs file.
}
\details{
\code{WriteXobs} writes a 'Xobs.txt' file, typically originating from an imported and modified 'Xobs.txt'.
HYPE Xobs files contain a three-row header, with a comment line first, next a line of variables, and then a line of subids.
Objects imported with \code{\link{ReadXobs}} include attributes holding this information, and \code{WriteXobs} will use this
information. Otherwise, these attributes can be added to objects prior to calling \code{WriteXobs}, or passed as function
arguments.

If argument \code{append} is \code{TRUE}, the function requires daily or hourly time steps as input.
The date-time column must be of class \code{POSIXct}, see \code{\link{as.POSIXct}}. Objects returned from
\code{\link{ReadXobs}} per default have the correct class for the date-time column. When appending to existing file, the
function adds new rows with '-9999' values in all data columns to fill any time gaps between existing and new data. If time
periods overlap, the export will stop with an error message. Argument \code{last.date} can be provided to speed up appending exports,
but per default, \code{WriteXobs} extracts the last observation in the existing file automatically.
}
\note{
Both \code{variable} and \code{subid} do not include elements for the first column in the Xobs file/object, in accordance
with \code{\link{ReadXobs}}. These elements will be added by the function.
}
\examples{
te <- ReadXobs(filename = system.file("demo_model", "Xobs.txt", package = "HYPEtools"))
WriteXobs(x = te, filename = tempfile())

}
