% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/high_dimensional_mean_comparison.R
\name{simple_pc_testing}
\alias{simple_pc_testing}
\title{Simple plug-in test for two-sample mean comparison.}
\usage{
simple_pc_testing(
  sample_1,
  sample_2 = NULL,
  pca_method = "sparse_pca",
  mean_method = "naive",
  num_latent_factor = 1,
  n_folds = 5,
  verbose = TRUE
)
}
\arguments{
\item{sample_1}{Group 1 sample. Each row is a subject and each column corresponds to a feature.}

\item{sample_2}{Group 2 sample. Each row is a subject and each column corresponds to a feature.}

\item{pca_method}{Methods used to estimate principle component The default is "sparse_pca", using sparse PCA from package PMA. Other choices are "dense_pca"---the regular PCA; and "hard"--- hard-thresholding PCA, which also induces sparsity.}

\item{mean_method}{Methods used to estimate the mean vector. Default is sample mean "naive". There is also a hard-thresholding sparse estiamtor "hard".}

\item{num_latent_factor}{Number of principle to be estimated/tested. Default is 1.}

\item{n_folds}{Number of splits when performing cross-fitting. The default is 5, if computational time allows, you can try to set it to 10.}

\item{verbose}{Print information to the console. Default is TRUE.}
}
\value{
A list of test statistics.
\item{test_statistics}{Test statistics. Each entry corresponds to the test result of one principle component.}
\item{standard_error}{Estimated standard error of test_statistics_before_studentization.}
\item{test_statistics_before_studentization}{Similar to test_statistics but does not have variance = 1.}
\item{split_data}{Intermediate quantities needed for further assessment and interpretation of the test results.}
}
\description{
Simple plug-in test for two-sample mean comparison.
}
\examples{
sample_size_1 <- sample_size_2 <- 300
true_mean_1 <- matrix(c(rep(1, 10), rep(0, 90)), ncol = 1)
true_mean_2 <- matrix(c(rep(1.5, 10), rep(0, 90)), ncol = 1)
pc1 <- c(rep(1, 10), rep(0, 90))
pc1 <- pc1/norm(pc1, type = '2')

simulation_covariance <- 10 * pc1 \%*\% t(pc1)
simulation_covariance <- simulation_covariance + diag(1, 100)

sample_1 <- data.frame(MASS::mvrnorm(sample_size_1,
                                     mu = true_mean_1,
                                     Sigma = simulation_covariance))
sample_2 <- data.frame(MASS::mvrnorm(sample_size_2,
                                     mu = true_mean_2,
                                     Sigma = simulation_covariance))
result <- simple_pc_testing(sample_1, sample_2)
result$test_statistics
##these are test statistics. Each one of them corresponds to one PC.
summarize_pc_name(result, latent_fator_index = 1) #shows which features contribute to PC1
extract_pc(result) # extract the estimated leading PCs.

}
