% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustModes.R
\name{clustModes}
\alias{clustModes}
\title{Hierarchical clustering of density modes}
\usage{
clustModes(modes, cutree.args, hclust.args = NULL, dist.args = NULL)
}
\arguments{
\item{modes}{An object of class 'HMMVBclust' returned by \code{hmmvbFindModes()}.}

\item{cutree.args}{A list with arguments to \code{cutree} method from package \code{stats}.}

\item{hclust.args}{A list with arguments to \code{hclust} method from package \code{stats}. It is used to 
specify a linkage method for hierarchical clustering of density modes. Complete linkage is used by default.
See \code{hclust} for details.}

\item{dist.args}{A list with arguments to \code{dist} method from package \code{stats}. It is used to 
specify a distance metric for the density modes. Euclidian distance is used by default. See \code{dist} for details.}
}
\value{
An object of class 'HMMVBclust' with new cluster labels and cluster sizes. Note that coordinates of modes after merging are not calculated and 
\code{clustParam} field is empty.
}
\description{
This function performs hierarchical clustering of density modes found
by \code{hmmvbFindModes()}.
}
\examples{
Vb <- vb(1, dim=4, numst=2)
set.seed(12345)
hmmvb <- hmmvbTrain(unique(iris[,1:4]), VbStructure=Vb)
modes <- hmmvbFindModes(unique(iris[,1:4]), model=hmmvb)

# default mode clustering
merged <- clustModes(modes, cutree.args=list(h=1.0))

# mode clustering using Manhattan distance
merged <- clustModes(modes, dist.args=list(method="manhattan"), cutree.args=list(h=1.0))

# mode clustering using single linkage
merged <- clustModes(modes, hclust.args=list(method="single"), cutree.args=list(h=1.0))
}
\seealso{
\code{\link{hmmvbClust}}, \code{\link{hmmvbFindModes}}
}
