% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deuteration_woods_plots.R
\name{deuteration_woods_timepoints}
\alias{deuteration_woods_timepoints}
\title{Return woods plots for the timepoints}
\usage{
deuteration_woods_timepoints(
  input_data,
  times,
  replicates = 3,
  cola = NA,
  ylim = c(0, 120),
  ...
)
}
\arguments{
\item{input_data}{output from function output_tp(..., percent=TRUE)}

\item{times}{Deuteration times, if missing all deuteration times used}

\item{replicates}{replicates}

\item{cola}{colors, default NA}

\item{ylim}{y axis limits}

\item{...}{other parameters}
}
\value{
Woods plots for the timepoints
}
\description{
All the peptides are plotted based on their uptake.
}
\examples{
\donttest{
file_nm<-system.file("extdata", "All_results_table.csv", package = "HDXBoxeR")
a<- output_tp(file_nm, percent=TRUE)
deuteration_woods_timepoints(a[1:12,])
}
}
