% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tools_SpecTest.R
\name{SpecMulTest}
\alias{SpecMulTest}
\title{Statistical inference for high-dimensional spectral density matrix}
\usage{
SpecMulTest(Q, PVal, alpha = 0.05, seq_len = 0.01)
}
\arguments{
\item{Q}{Number of the hypothesis tests.}

\item{PVal}{P-values for the \eqn{Q} hypothesis tests, a \eqn{Q} vector.}

\item{alpha}{The prescribed significance level. Default is 0.05.}

\item{seq_len}{Length used to take discrete points between 0 and 
\eqn{\sqrt(2\times\log(Q)-2\times\log(\log(Q))}. Default is 0.01.}
}
\value{
An object of class "hdtstest" is a list containing the following
  components:
  \item{MultiTest}{Logical vector with length Q. If the element is \code{TRUE}, 
  it means rejecting the corresponding sub-null hypothesis, otherwise it means 
  not rejecting the corresponding sub-null hypothesis.}
}
\description{
\code{SpecMulTest()} implements a new multiple test proposed in
 Chang, Jiang, McElroy and Shao (2023) for the \eqn{Q} hypothesis testing problems: 
\deqn{H_{0,q}:f_{i,j}(\omega)=0\mathrm{\ for\ any\ }(i,j)\in\mathcal{I}^{(q)}\mathrm{\ and\ }
\omega\in\mathcal{J}^{(q)}\mathrm{\ \ versus\ \ }
H_{1,q}:H_{0,q}\mathrm{\ is\ not\ true.} }
for \eqn{q\in\{1,\dots,Q\}}.
}
\examples{
n <- 200
p <- 10
flag_c <- 0.8
B <- 1000
burn <- 1000
z.sim <- matrix(rnorm((n+burn)*p),p,n+burn)
phi.mat <- 0.4*diag(p)
x.sim <- phi.mat \%*\% z.sim[,(burn+1):(burn+n)]
x <- x.sim - rowMeans(x.sim)
Q <- 4
ISET <- list()
ISET[[1]] <- matrix(c(1,2),ncol=2)
ISET[[2]] <- matrix(c(1,3),ncol=2)
ISET[[3]] <- matrix(c(1,4),ncol=2)
ISET[[4]] <- matrix(c(1,5),ncol=2)
JSET <- as.list(2*pi*seq(0,3)/4 - pi)
PVal <- rep(NA,Q)
for (q in 1:Q) {
  cross.indices <- ISET[[q]]
  J.set <- JSET[[q]]
  temp.q <- SpecTest(t(x), J.set, cross.indices, B, flag_c)
  PVal[q] <- temp.q$p.value
}  # Q
res <- SpecMulTest(Q, PVal)
res

}
\references{
Chang, J., Jiang, Q., McElroy, T. & Shao, X. (2023). 
\emph{Statistical inference for high-dimensional spectral density matrix}.
}
