/*
 * Decompiled with CFR 0.152.
 */
package ObjectiveFunctions;

import ExperimentalDesign.Tools;
import ObjectiveFunctions.KernelObjective;
import ObjectiveFunctions.ObjectiveFunction;
import java.util.ArrayList;
import java.util.HashMap;

public class MultipleKernelObjectiveFunction
extends ObjectiveFunction {
    private double[] kernel_weights;
    private int m;
    private KernelObjective[] kernel_objective_functions;
    private double maximum_gain_scaling;
    private HashMap<Integer, Double> max_reduction_log_obj_vals;
    private ArrayList<double[]> kernel_obj_values;

    public MultipleKernelObjectiveFunction(HashMap<Integer, double[][]> hashMap, HashMap<Integer, Double> hashMap2, double[] dArray, double d, ArrayList<double[]> arrayList) {
        this.kernel_weights = dArray;
        this.max_reduction_log_obj_vals = hashMap2;
        this.maximum_gain_scaling = d;
        this.kernel_obj_values = arrayList;
        this.m = hashMap.size();
        this.kernel_objective_functions = new KernelObjective[this.m];
        for (int i = 0; i < this.m; ++i) {
            this.kernel_objective_functions[i] = new KernelObjective(hashMap.get(i));
        }
        System.out.println("MultipleKernelObjectiveFunction init m = " + this.m + " maximum_gain_scaling =  " + d + " kernel_weights = " + Tools.StringJoin(dArray));
    }

    @Override
    public double calc(boolean bl) {
        double d = 0.0;
        for (int i = 0; i < this.m; ++i) {
            d += this.kernel_weights[i] * this.pct_off_from_best(i);
        }
        return d;
    }

    public void calcKernelObjDiagnostics() {
        double[] dArray = new double[this.m];
        for (int i = 0; i < this.m; ++i) {
            dArray[i] = this.pct_off_from_best(i);
        }
        this.kernel_obj_values.add(dArray);
    }

    private double pct_off_from_best(int n) {
        double d = 1.0 - this.kernel_objective_functions[n].log10_i_over_current_obj_val() / (this.max_reduction_log_obj_vals.get(n) * this.maximum_gain_scaling);
        return d;
    }

    public void setW(int[] nArray) {
        for (int i = 0; i < this.m; ++i) {
            this.kernel_objective_functions[i].setW(nArray);
        }
    }

    public void setSwitch(int n, int n2) {
        for (int i = 0; i < this.m; ++i) {
            this.kernel_objective_functions[i].setSwitch(n, n2);
        }
    }

    public void resetKernelSum() {
        for (int i = 0; i < this.m; ++i) {
            this.kernel_objective_functions[i].resetKernelSum();
        }
    }

    public void setInitialObjVals() {
        for (int i = 0; i < this.m; ++i) {
            this.kernel_objective_functions[i].setInitialObjVal();
        }
    }
}

