% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{dropMetaPrograms}
\alias{dropMetaPrograms}
\title{Drop meta-programs}
\usage{
dropMetaPrograms(mp.res, dropMP = NULL)
}
\arguments{
\item{mp.res}{The meta-programs object generated by \code{\link{getMetaPrograms}}}

\item{dropMP}{A vector with the names of the MPs to be dropped}
}
\value{
The input meta-program object, minus the dropped MPs
}
\description{
Remove meta-programs from the GeneNMF results. This can be desirable if
one or more MPs are redundant or have poor metrics (e.g. low sample coverage
or low silhouette score).
}
\examples{
library(Seurat)
data(sampleObj)
geneNMF_programs <- multiNMF(list(sampleObj), k=5)
geneNMF_metaprograms <- getMetaPrograms(geneNMF_programs, nMP=3)
geneNMF_metaprograms_filtered <- dropMetaPrograms(geneNMF_metaprograms, dropMP = c("MP2")) 

}
