% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SuppressDirectDisclosure.R
\name{SuppressDirectDisclosure}
\alias{SuppressDirectDisclosure}
\title{Suppression of directly-disclosive cells}
\usage{
SuppressDirectDisclosure(
  data,
  dimVar,
  freqVar,
  coalition = 1,
  secondaryZeros = coalition,
  candidates = DirectDisclosureCandidates,
  ...
)
}
\arguments{
\item{data}{the input data}

\item{dimVar}{main dimensional variables for the output table}

\item{freqVar}{variable containing frequency counts}

\item{coalition}{numeric variable, parameter for primary suppression. Default value is 1.}

\item{secondaryZeros}{logical or numeric value for secondary suppression. If logical, it is converted to resp numeric value (0 or 1). If numeric, it describes the largest number that is prioritized over zeroes in secondary suppression. Default value is equal to coalition.}

\item{candidates}{function parameter for gauss suppression.}

\item{...}{optional parameters that can be passed to the primary suppression
method. See \link[SSBtools]{FindDisclosiveCells} for details.
In the case of SuppressDirectDisclosure2, \code{...} are parameters to GaussSuppressionFromData.}
}
\value{
data.frame containing the result of the suppression
}
\description{
Function for suppressing directly-disclosive cells in frequency tables. The method
detects and primary suppresses directly-disclosive cells with the
\link[SSBtools]{FindDisclosiveCells} function, and applies a secondary suppression
using Gauss suppression (see \link{GaussSuppressionFromData}).
}
\details{
SuppressDirectDisclosure has no support for hierarchical data.
SuppressDirectDisclosure2 has, but is less general in other ways.
}
\examples{
tex <- data.frame(v1 = rep(c('a', 'b', 'c'), times = 4),
                  v2 = c('i','i', 'i','h','h','h','i','i','i','h','h','h'),
                  v3 = c('y', 'y', 'y', 'y', 'y', 'y','z','z', 'z', 'z', 'z', 'z'),
                  freq = c(0,0,5,0,2,3,1,0,3,1,1,2))
SuppressDirectDisclosure(tex, c("v1", "v2", "v3"), "freq")
SuppressDirectDisclosure(tex, c("v1", "v2", "v3"), "freq", coalition = 2, unknown.threshold = 10)

z3 <- SSBtools::SSBtoolsData("z3")
a1 <- SuppressDirectDisclosure(z3, c(1, 4, 5), 7)
b1 <- try(SuppressDirectDisclosure(z3, 1:6, 7))

}
\author{
Daniel Lupp
}
