% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{nonDomSet}
\alias{nonDomSet}
\title{Non-dominated points with respect to a reference}
\usage{
nonDomSet(points, ref)
}
\arguments{
\item{points}{matrix (one point per row) that are compared to a reference \code{ref} (i.e., not between themselves)}

\item{ref}{matrix (one point per row) of reference (faster if they are already Pareto optimal)}
}
\description{
Determines which elements in a set are dominated by reference points
}
\examples{
\dontrun{
d <- 6
n <- 1000
n2 <- 1000

test <- matrix(runif(d * n), n)
ref <- matrix(runif(d * n), n)
indPF <- nonDomInd(ref)

system.time(res <- nonDomSet(test, ref[indPF,,drop = F]))

res2 <- rep(NA, n2)
library(emoa)
t0 <- Sys.time()
for(i in 1:n2){
  res2[i] <- !is_dominated(t(rbind(test[i,, drop = F], ref[indPF,])))[1]
}
print(Sys.time() - t0)

all(res == res2)
}
}
