% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gnrs_super_simple.R
\name{GNRS_super_simple}
\alias{GNRS_super_simple}
\title{Standardize political division names}
\usage{
GNRS_super_simple(
  country = NULL,
  state_province = NULL,
  county_parish = NULL,
  user_id = NULL
)
}
\arguments{
\item{country}{A single country or a vector of countries.  If a vector, length must equal length of species vector.}

\item{state_province}{A single state/province or a vector of states.  If a vector, length must equal length of species vector.}

\item{county_parish}{A single county/parish or a vector of counties.  If a vector, length must equal length of species vector.}

\item{user_id}{A single user id to be appended to results (optional).}
}
\value{
Dataframe containing GNRS results.
}
\description{
GNRS_super_simple returns standardized political division names (according to geonames.org).
}
\examples{
{

 results <- GNRS_super_simple(country = "United States of America")
 results <- GNRS_super_simple(
             country = "United States",
             state_province = "Arizona",
             county_parish = "Pima County")

}
}
