% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{plotICC}
\alias{plotICC}
\title{Plot item characteristic curves (ICCs)}
\usage{
plotICC(IP, Th, items = NULL, quiet = FALSE)
}
\arguments{
\item{IP}{Object of class \code{GGUM}.}

\item{Th}{Theta estimates from function \code{Theta.EAP()}.}

\item{items}{Vector indicating the items for which the ICCs are to be 
plotted. Default is all items.}

\item{quiet}{Render all plots for \code{items} at once? Default is 
\code{FALSE}.}
}
\value{
The function returns the correlation between observed and expected 
  item scores (missing values pairwise removed).
}
\description{
\code{plot.ICC} plots the ICCs for the GUM and the GGUM.
}
\section{Details}{
 This function plots the item characteristic curves (ICCs).
}

\examples{
\dontrun{
# For GUM:
# Generate data
#   (toy example: Too few items (due to computation time constraints) for 
#   accurate estimation of person parameters; larger number of items is 
#   required in practice):
gen1 <- GenData.GGUM(400, 5, 3, "GUM", seed = 139)
# Fit the GUM:
fit1 <- GUM(gen1$data, 3)
th1  <- Theta.EAP(fit1)
# Plot ICCs:
plotICC(fit1, th1, items = 1, quiet = TRUE)
}
\dontrun{
# For GGUM:
# Generate data:
set.seed(1); C <- sample(3:5, 10, replace = TRUE)
gen2 <- GenData.GGUM(2000, 10, C, "GGUM", seed = 156)
# Fit the GGUM:
fit2 <- GGUM(gen2$data, C)
th2  <- Theta.EAP(fit2)
# Plot ICCs:
plotICC(fit2, th2, items = 1, quiet = TRUE)
}

}
\author{
Jorge N. Tendeiro, \email{j.n.tendeiro@rug.nl}
}
