% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggm_inference.R
\name{ggm_inference}
\alias{ggm_inference}
\title{Gaussian graphical model: statistical inference}
\usage{
ggm_inference(
  Y,
  alpha = 0.05,
  control_precision = FALSE,
  boot = TRUE,
  B = 1000,
  cores = 2,
  method = "pearson",
  progress = TRUE
)
}
\arguments{
\item{Y}{The data matrix of dimensions \emph{n} (observations) by \emph{p} (nodes).}

\item{alpha}{The desired significance level (defaults to \code{0.05}). Note that
1 - alpha corresponds to specificity.}

\item{control_precision}{Logical. Should precision (i.e., 1 - false discovery rate)
be controlled at the level alpha (defaults to \code{FALSE}) ?}

\item{boot}{Logical. Should a non-parametric bootstrap be employed (defaults to \code{TRUE})?}

\item{B}{Integer. Number of bootstrap replicates (defaults to \code{1000}).}

\item{cores}{Integer. Number of cores to be used when executing in parallel.}

\item{method}{Character string. Which type of correlation coefficients
to be computed. Options include \code{"pearson"} (default),
\code{"kendall"}, \code{"spearman"}, and \code{"polychoric"}.}

\item{progress}{Logical. Should a progress bar be included (defaults to \code{TRUE})?}
}
\value{
An object of class \code{ggm_inference}
}
\description{
Learn the conditional dependence structure with null hypothesis
             significance testing. This provides a valid measure of parameter
             uncertainty.
}
\examples{
\donttest{

Y <- ptsd

fit <- ggm_inference(Y)

}

}
