% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggm_compare.R
\name{ggm_compare}
\alias{ggm_compare}
\title{Compare Gaussian Graphical Models}
\usage{
ggm_compare(object_1, object_2, method = "fdr", alpha = 0.05, ...)
}
\arguments{
\item{object_1}{An object of class \code{ggmncv}}

\item{object_2}{An object of class \code{ggmncv}}

\item{method}{Character string. A correction method for multiple comparison (defaults to \code{fdr}).
Can be abbreviated. See \link[stats]{p.adjust}.}

\item{alpha}{Numeric. Significance level (defaults to \code{0.05}).}

\item{...}{Currently ignored.}
}
\value{
\itemize{

\item \code{P_diff} De-sparsified partial correlation matrix differences

\item \code{adj} Adjacency matrix based on the p-values.

\item \code{uncorrected} Uncorrected p-values

\item \code{corrected} Corected p-values

\item \code{method} The approach used for multiple comparisons

\item \code{alpha} Significance level
}
}
\description{
Compare Gaussian graphical models with the de-sparsified estimator of
\insertCite{jankova2015confidence}{GGMncv}.
}
\examples{
# data
Y1 <- MASS::mvrnorm(250, rep(0, 10), Sigma = diag(10))
Y2 <- MASS::mvrnorm(250, rep(0, 10), Sigma = diag(10))

# fit models
fit1 <- ggmncv(cor(Y1), n = nrow(Y1))
fit2 <- ggmncv(cor(Y2), n = nrow(Y2))

# compare
compare_ggms <- ggm_compare(fit1, fit2)
}
