% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTL.R
\name{plotTL}
\alias{plotTL}
\title{Produces a line plot of Temperature and Light.}
\usage{
plotTL(AccData, start = NULL, end = NULL, length = NULL,
  resolution = 100)
}
\arguments{
\item{AccData}{object to plot, can be matrix or AccData object.}

\item{start}{Start of Data to plot. Passed to get.intervals, see code{\link[GENEAread]{get.intervals}}}

\item{end}{End of Data to plot.}

\item{length}{Length of interval}

\item{resolution}{Resolution to plot the data given the data's frequency.}
}
\description{
3 line plot of Temperature and Light.
}
\details{
From the raw data to create a representation of Light and Temperature.

Creates a temperature and ligth plot with 2 distinct axis from epoched data. The epoch is dependent on the resolution.
}
\examples{

\dontrun{
x = readRDS(system.file("extdata", "AccData.rds", package = "GENEAsphere"))
plotTL(x)
}
}
