% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemparm.GDINA.R
\name{itemparm}
\alias{itemparm}
\title{extract lower-order structural (item) parameters}
\usage{
itemparm(object, what = c("catprob", "gs", "delta", "rrum", "itemprob",
  "LCprob"), withSE = FALSE, SE.type = 2, digits = 4, ...)
}
\arguments{
\item{object}{estimated GDINA object returned from \code{\link{GDINA}}}

\item{what}{what to show; It can be \code{"itemprob"} for
item success probabilities of each reduced attribute pattern, \code{"catprob"} for
category success probabilities of each reduced attribute pattern, \code{"LCprob"} for
item success probabilities of each attribute pattern, \code{"gs"} for guessing and slip parameters,
\code{"delta"} for delta parameters, \code{"rrum"} for RRUM parameters when items
are estimated using RRUM and \code{"higher.order"} for higher-order IRT
parameters. The default is \code{"itemprob"}.}

\item{withSE}{show standard errors or not?}

\item{SE.type}{type of standard errors.}

\item{digits}{how many decimal places for the ouput?}

\item{...}{additional arguments}
}
\description{
Function to extract various item parameters, including \code{"itemprob"} for
item success probabilities of each reduced attribute pattern, \code{"catprob"} for
category success probabilities of each reduced attribute pattern, \code{"LCprob"} for
item success probabilities of each attribute pattern,\code{"gs"} for guessing and slip parameters,
\code{"delta"} for delta parameters, \code{"rrum"} for RRUM parameters when items
are estimated using RRUM and \code{"higher.order"} for higher-order IRT
parameters. Standard errors can be estimated if \code{withSE = TRUE}.
See \code{\link{GDINA}} for examples.
}
\author{
{Wenchao Ma, Rutgers University, \email{wenchao.ma@rutgers.edu} \cr Jimmy de la Torre, The University of Hong Kong}
}
