% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residualsfun.R
\name{arrange_hres}
\alias{arrange_hres}
\title{Re-arrange the multi-step residuals}
\usage{
arrange_hres(list_res)
}
\arguments{
\item{list_res}{a list of \mjseqn{H} multi-step residuals. Each element
of the list can be a vector (univariate time series) or a matrix (multivariate time series).}
}
\value{
A vector or a matrix of multi-step residuals
}
\description{
Re-arrange the multi-step residuals
}
\details{
Let \mjseqn{Z_t}, \mjseqn{t=1,\dots,T}, be a univariate time series. We can define the multi-step
residuals such us
\mjsdeqn{\widehat{\varepsilon}_{h,t} = Z_{t+h} - \widehat{Z}_{t+h|t} \qquad h \le t \le T-h}
where \mjseqn{\widehat{Z}_{t+h|t}} is the \mjseqn{h}-step fitted value, calculated as the \mjseqn{h}-step ahead
forecast given the time \mjseqn{t}. Given the list of errors at different step
(\mjseqn{[\widehat{\varepsilon}_{1,1}, \; \dots, \; \widehat{\varepsilon}_{1,T}]}, ..., \mjseqn{[\widehat{\varepsilon}_{H,1}, \; \dots, \; \widehat{\varepsilon}_{H,T}]})
this function returns a \mjseqn{T}-vector with the residuals, organized in the following way:
\mjsdeqn{[\varepsilon_{1,1} \; \varepsilon_{2,2} \; \dots \; \varepsilon_{H,H} \; \varepsilon_{1,H+1} \; \dots \; \varepsilon_{H,T-H}]'}
Same idea can be apply for a multivariate time series.
}
\seealso{
Other utilities: 
\code{\link{Cmatrix}()},
\code{\link{FoReco2ts}()},
\code{\link{agg_ts}()},
\code{\link{commat}()},
\code{\link{ctf_tools}()},
\code{\link{hts_tools}()},
\code{\link{lcmat}()},
\code{\link{oct_bounds}()},
\code{\link{residuals_matrix}()},
\code{\link{score_index}()},
\code{\link{shrink_estim}()},
\code{\link{thf_tools}()}
}
\concept{utilities}
