% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk.max.doy.R
\name{pk.max.doy}
\alias{pk.max.doy}
\title{Day of year for annual maximum series}
\usage{
pk.max.doy(TS)
}
\arguments{
\item{TS}{data.frame of streamflow time series loaded with \code{\link{read.flows}}.}
}
\value{
Returns a numeric vector containing the day of the (hydrologic) year for 
  each annual maximum flow. The "times" attribute contains the 
  hydrologic year for each element in the vector.
}
\description{
This function returns the day of the hydrologic year for each annual maximum flow.
}
\examples{
data(caniapiscau)
cania.ts <- create.ts(caniapiscau, hyrstart = 4)
cania.ts <- drop.years(cania.ts)
cania.ts <- set.plot.titles(cania.ts, 
title.elements = c("StationID", "StnName", "StateProv"))

res <- pk.max.doy(cania.ts)
res2 <- screen.metric(res, ylabel = "Day of Year", title = TRUE)
}
\seealso{
See \code{\link{create.ts}} to format the input flow series.

  See \code{\link{pk.max}} for the annual maximum flow series.
}
\author{
Jennifer Dierauer
}
