% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Summaries.R, R/coefficients.R
\name{summary.flexreg}
\alias{summary.flexreg}
\alias{print.summary.flexreg}
\alias{coef.flexreg}
\title{Methods for flexreg Objects}
\usage{
\method{summary}{flexreg}(object, ..., digits = 4)

\method{print}{summary.flexreg}(x, ...)

\method{coef}{flexreg}(object, ...)
}
\arguments{
\item{object}{an object of class \code{`flexreg`}, usually the result of \code{\link{flexreg}}.}

\item{...}{additional arguments. Currently not used.}

\item{digits}{an integer indicating the number of decimal places. Default equal to 4.}

\item{x}{an object of class \code{`flexreg`}, usually the result of \code{\link{flexreg}}.}
}
\description{
Methods for extracting information from fitted  regression model objects of class \code{`flexreg`}.
}
\details{
The \code{summary.flexreg} method summarizes the results of \code{\link{flexreg}}, adding also information from the functions
\code{\link{residuals.flexreg}} and \code{\link{WAIC}}. The \code{summary.flexreg} method returns an object of class \code{`summary.flexreg`} containing the relevant summary statistics which can subsequently be
printed using the associated \code{print} method.
}
\examples{
data("Reading")
dataset <- Reading
FB <- flexreg(accuracy ~ iq, dataset, n.iter = 1000)
summary(FB)

}
