% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densities.R
\name{dFB}
\alias{dFB}
\title{Flexible beta probability density function}
\usage{
dFB(x, mu, phi, p, w)
}
\arguments{
\item{x}{a vector of quantiles.}

\item{mu}{the mean parameter of the flexible beta distribution. It must lie in (0, 1).}

\item{phi}{the precision parameter of the flexible beta distribution. It must be a positive real value.}

\item{p}{the mixing weight. It must lie in (0, 1).}

\item{w}{the normalized distance among clusters. It must lie in (0, 1).}
}
\value{
A vector with the same length as \code{x}.
}
\description{
The function computes the probability density function of the flexible beta distribution.
}
\details{
The FB distribution is a special mixture of two beta distributions
\deqn{p Beta(x|\lambda_1,\phi)+(1-p)Beta(x|\lambda_2,\phi)}
 for \eqn{0<x<1} where \eqn{Beta(x|\cdot,\cdot)} is the beta distribution with a mean-precision parameterization.
 Moreover, \eqn{0<p<1} is the mixing weight, \eqn{\phi>0} is a precision parameter,
 \eqn{\lambda_1=\mu+(1-p)w} and \eqn{\lambda_2=\mu-pw} are the component means of the first and second component of the mixture,
 \eqn{0<\mu=p\lambda_1+(1-p)\lambda_2<1} is the overall mean, and \eqn{0<w<1} is the  normalized distance between clusters.
}
\examples{
dFB(x = c(.5,.7,.8), mu = 0.3, phi = 20, p = .5, w = .5)

}
\references{
{
Migliorati, S., Di Brisco, A. M., Ongaro, A. (2018). A New Regression Model for Bounded Responses. Bayesian Analysis, \bold{13}(3), 845--872. doi:10.1214/17-BA1079
}
}
