\name{FamiliasPedigree}
\alias{FamiliasPedigree}

\title{
Creates an object storing a pedigree.  
}
\description{
Creates and stores an object containing a pedigree in much the same way as the 'pedigree' 
function of the 'kinship2' package. It is checked that the input represents a correct pedigree. 
The main differences is that a person is allowed to have one parent present and one absent in the pedigree. 
Another difference is that no disease parameters are included. 
The result is an object with class \code{FamiliasPedigree}
}
\usage{
FamiliasPedigree(id, dadid, momid, sex)
}

\arguments{
  \item{id}{
A vector containing unique identifiers of all individuals in the pedigree.
}
  \item{dadid}{
Indicates the fathers of individuals. The vector must have the same length as the id vector and contain either 
values from it, indicating that the individual with this position in the id vector has the given father, or NA. 
}
  \item{momid}{
Indicates the mothers of individuals. The vector must have the same length as the id vector and contain either 
values from it, indicating that the individual with this position in the id vector has the given mother, or NA. 
}
  \item{sex}{
A vector of the same length as the id vector, indicating the gender of individuals. 
Values must be either "female" or "male". 
}
}
\details{
The objects created by the \code{FamiliasPedigree} function represent both a simplification and a 
generalization of the objects generated by the 'pedigree' function of the 'kinship2' package. 
It is a simplification in that parameters concerning disease are dropped, but it is a generalization 
in the sense that persons are allowed to have exactly one parent present in the pedigree. 
This generalization is necessary for the Familias package, as results from the \code{FamiliasPosterior}
function may change when a single ancestor (father or mother) is added to a single person in a
pedigree. Such changes may occur when a non-zero mutation rate is used together with a non-stable 
mutation model. The \code{FamiliasPosterior} and \code{FamiliasPrior} functions can use either pedigree type as input. 
}
\value{
A list of class \code{FamiliasPedigree} containing 
\item{id}{The same vector as the id input}
\item{findex}{A vector of indices of fathers of persons. Zero indicates that the person has no father in the pedigree.}
\item{mindex}{A vector of indices of mothers of persons. Zero indicates that the person has no mother in the pedigree.}
\item{sex}{The same vector as the sex input}
}
\author{
Petter Mostad mostad@chalmers.se
}

\examples{
#A nuclear family of three: 
ped <- FamiliasPedigree(c("mother", "father", "child"), 
                        c(NA, NA, "father"), 
                        c(NA, NA, "mother"), 
                        c("female", "male", "female"))
plot(ped, symbolsize = 2, cex = 2, family = "mono")

#Generating the two pedigrees needed for a traditional paternity case
ped1 <- FamiliasPedigree(c("mother", "child", "AF"), 
                         c(NA, NA, NA), 
                         c(NA, "mother", NA), 
                         c("female", "female", "male"))
ped2 <- FamiliasPedigree(c("mother", "child", "AF"), 
                         c(NA, "AF", NA), 
                         c(NA, "mother", NA), 
                         c("female", "female", "male"))

#Generating the two pedigrees needed for a duo case
ped1 <- FamiliasPedigree(c("child", "AF"), c(NA, NA), c(NA, NA), c("male", "male"))
ped2 <- FamiliasPedigree(c("child", "AF"), c("AF", NA), c(NA, NA), c("male", "male"))
}