% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{res2tex}
\alias{res2tex}
\title{Facility to export the results of multiple \code{femlm} estimations in a Latex table.}
\usage{
res2tex(..., se = c("standard", "white", "cluster", "twoway", "threeway",
  "fourway"), cluster, digits = 4, pseudo = TRUE, title,
  sdBelow = TRUE, drop, order, dict, file, append = TRUE, convergence,
  signifCode = c(`***` = 0.01, `**` = 0.05, `*` = 0.1), label,
  aic = FALSE, sqCor = FALSE, subtitles, showClusterSize = FALSE,
  bic = TRUE, loglik = TRUE, yesNoCluster = c("Yes", "No"),
  keepFactors = FALSE, family, powerBelow = -5)
}
\arguments{
\item{...}{Used to capture different \code{\link[FENmlm]{femlm}} objects. Note that any other type of element is discarded. Note that you can give a list of \code{\link[FENmlm]{femlm}} objects.}

\item{se}{Character scalar. Which kind of standard error should be computed: \dQuote{standard} (default), \dQuote{White}, \dQuote{cluster}, \dQuote{twoway}, \dQuote{threeway} or \dQuote{fourway}?}

\item{cluster}{A list of vectors. Used only if \code{se="cluster"}, \dQuote{se=twoway}, \dQuote{se=threeway} or \dQuote{se=fourway}. The vectors should give the cluster of each observation. Note that if the estimation was run using \code{cluster}, the standard error is automatically clustered along the cluster given in \code{\link[FENmlm]{femlm}}. For one-way clustering, this argument can directly be a vector (instead of a list). If the estimation has been done with cluster variables, you can give a character vector of the dimensions over which to cluster the SE.}

\item{digits}{Integer, default is 4. The number of digits to be displayed.}

\item{pseudo}{Logical, default is \code{TRUE}. Should the pseudo R2 be displayed?}

\item{title}{Character scalar. The title of the Latex table.}

\item{sdBelow}{Logical, default is \code{TRUE}. Should the standard-errors be displayed below the coefficients?}

\item{drop}{Character vector. This element is used if some variables are not to be displayed. This should be a regular expression (see \code{\link[base]{regex}} help for more info). There can be more than one regular expression. Each variable satisfying the regular expression will be discarded.}

\item{order}{Character vector. This element is used if the user wants the variables to be ordered in a certain way. This should be a regular expression (see \code{\link[base]{regex}} help for more info). There can be more than one regular expression. The variables satisfying the first regular expression will be placed first, then the order follows the sequence of regular expressions.}

\item{dict}{A named character vector. If provided, it changes the original variable names to the ones contained in the \code{dict}. Example: I want to change my variable named "a" to "$log(a)$" and "b3" to "$bonus^3$", then I used \code{dict=c(a="$log(a)$",b3="$bonus^3$")}.}

\item{file}{A character scalar. If provided, the Latex table will be saved in a file whose path is \code{file}.}

\item{append}{Logical, default is \code{TRUE}. Only used if option \code{file} is used. Should the Latex table be appended to the existing file?}

\item{convergence}{Logical, default is missing. Should the convergence state of the algorithm be displayed? By default, convergence information is displayed if at least one model did not converge.}

\item{signifCode}{Named numeric vector, used to provide the significance codes with respect to the p-value of the coefficients. Default is \code{c("***"=0.01, "**"=0.05, "*"=0.10)}.}

\item{label}{Character scalar. The label of the Latex table.}

\item{aic}{Logical, default is \code{FALSE}. Should the AIC be displayed?}

\item{sqCor}{Logical, default is \code{FALSE}. Should the squared correlation be displayed?}

\item{subtitles}{Character vector of the same lenght as the number of models to be displayed. If provided, subtitles are added underneath the dependent variable name.}

\item{showClusterSize}{Logical, default is \code{FALSE}. If \code{TRUE} and clusters were used in the models, then the number "individuals" of per cluster is also displayed.}

\item{bic}{Logical, default is \code{TRUE}.Should the BIC be reported?}

\item{loglik}{Logical, default is \code{TRUE}. Should the log-likelihood be reported?}

\item{yesNoCluster}{A character vector of lenght 2. Default is \code{c("Yes", "No")}. This is the message displayed when a given cluster is (or is not) included in a regression.}

\item{keepFactors}{Logical, default is \code{FALSE}. By default, when factor variables are contained in the estimation, they are printed as if they were a cluster variable. Put to \code{TRUE} to display all the coefficients of the factor variables.}

\item{family}{A logical, default is missing. Whether to display the families of the models. By default this line is displayed when at least two models are from different families.}

\item{powerBelow}{Integer, default is -5. A coefficient whose value is below \code{10**(powerBelow+1)} is written with a power in Latex. For example \code{0.0000456} would be written \code{4.56$\\times 10^{-5}$} by default. Setting \code{powerBelow = -6} would lead to \code{0.00004} in Latex.}
}
\value{
There is nothing returned, the result is only displayed on the console or saved in a file.
}
\description{
This function aggregates the results of multiple estimations and display them in the form of  one Latex table whose rownames are the variables and the columns contain the coefficients and standard-errors.
}
\examples{

# two fitted models with different expl. variables:
res1 = femlm(Sepal.Length ~ Sepal.Width + Petal.Length +
            Petal.Width | Species, iris)
res2 = femlm(Sepal.Length ~ Petal.Width | Species, iris)

# We export the three results in one Latex table,
# with clustered standard-errors:
res2tex(res1, res2, se = "cluster")

# Changing the names & significance codes
res2tex(res1, res2, dict = c(Sepal.Length = "The sepal length", Sepal.Width = "SW"),
        signifCode = c("**" = 0.1, "*" = 0.2, "n.s."=1))

}
\seealso{
See also the main estimation function \code{\link[FENmlm]{femlm}}. Use \code{\link[FENmlm]{summary.femlm}} to see the results with the appropriate standard-errors, \code{\link[FENmlm]{getFE}} to extract the cluster coefficients, and the functions \code{\link[FENmlm]{res2table}} and \code{\link[FENmlm]{res2tex}} to visualize the results of multiple estimations.
}
\author{
Laurent Berge
}
