% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constrainedX.R
\name{anisotropic_Kronecker}
\alias{anisotropic_Kronecker}
\alias{\%A\%}
\alias{\%A0\%}
\alias{\%Xa0\%}
\title{Kronecker product or row tensor product of two base-learners with anisotropic penalty}
\usage{
bl1 \%A\% bl2

bl1 \%A0\% bl2

bl1 \%Xa0\% bl2
}
\arguments{
\item{bl1}{base-learner 1, e.g. \code{bbs(x1)}}

\item{bl2}{base-learner 2, e.g. \code{bbs(x2)}}
}
\description{
Kronecker product or row tensor product of two base-learners allowing for anisotropic penalties. 
For the Kronecker product, \code{\%A\%} works in the general case, \code{\%A0\%} for the special case where 
the penalty is zero in one direction. 
For the row tensor product, \code{\%Xa0\%} works for the special case where 
the penalty is zero in one direction.
}
\details{
When \code{\%O\%} is called with a specification of \code{df} in both base-learners, 
e.g. \code{bbs(x1, df = df1) \%O\% bbs(t, df = df2)}, the global \code{df} for the 
Kroneckered base-learner is computed as \code{df = df1 * df2}. 
And thus the penalty has only one smoothness parameter lambda resulting in an isotropic penalty, 
\deqn{P = lambda * [(P1 o I) + (I o P2)],} 
with overall penalty \eqn{P}, Kronecker product \eqn{o}, 
marginal penalty matrices \eqn{P1, P2} and identity matrices \eqn{I}.  
(Currie et al. (2006) introduced the generalized linear array model, which has a design matrix that 
is composed of the Kronecker product of two marginal design matrices, which was implemented in mboost 
as \code{\%O\%}.  
See Brockhaus et al. (2015) for the application of array models to functional data.)  

In contrast, a Kronecker product with anisotropic penalty is obtained by \code{\%A\%}, 
which allows for a different amount of smoothness in the two directions. 
For example \code{bbs(x1, df = df1) \%A\% bbs(t, df = df2)} results in computing two
different values for lambda for the two marginal design matrices and a global value of 
lambda to adjust for the global \code{df}, i.e. 
\deqn{P = lambda * [(lambda1 * P1 o I) +  (I o lambda2 * P2)],} 
with Kronecker product \eqn{o}, 
where \eqn{lambda1} is computed individually for \eqn{df1} and \eqn{P1}, 
\eqn{lambda2} is computed individually for \eqn{df2}  and \eqn{P2}, 
and \eqn{lambda} is computed such that the global \eqn{df} hold \eqn{df = df1 * df2}. 
For the computation of \eqn{lambda1} and \eqn{lambda2} weights specified in the model 
call can only be used when the weights, are such that they are specified on the level 
of rows and columns of the response matrix Y, e.g. resampling weights on the level of 
rows of Y and integration weights on the columns of Y are possible. 
If this the weights cannot be separated to blg1 and blg2 all
weights are set to 1 for the computation of \eqn{lambda1} and \eqn{lambda2} which implies that 
\eqn{lambda1} and \eqn{lambda2} are equal over 
folds of \code{cvrisk}. The computation of the global \eqn{lambda} considers the 
specified \code{weights}, such the global \eqn{df} are correct.    

The operator \code{\%A0\%} treats the important special case where \eqn{lambda1 = 0} or 
\eqn{lambda2 = 0}. In this case it suffices to compute the global lambda and computation gets
faster and arbitrary weights can be specified. Consider \eqn{lambda1 = 0} then the penalty becomes 
\deqn{P = lambda * [(1 * P1 o I) +  (I o lambda2 * P2)] = lambda * lambda2 * (I o P2),}  
and only one global \eqn{lambda} is computed which is then  \eqn{lambda * lambda2}.  
     
If the \code{formula} in \code{FDboost} contains base-learners connected by 
\code{\%O\%}, \code{\%A\%} or \code{\%A0\%}, 
those effects are not expanded with \code{timeformula}, allowing for model specifications 
with different effects in time-direction.  

\code{\%Xa0\%} computes like \code{\%X\%} the row tensor product of two base-learners, 
with the difference that it sets the penalty for one direction to zero. 
Thus, \code{\%Xa0\%} behaves to \code{\%X\%} analogously like \code{\%A0\%} to \code{\%O\%}.
}
\examples{
 
######## Example for anisotropic penalty  
data("viscosity", package = "FDboost") 
## set time-interval that should be modeled
interval <- "101"

## model time until "interval" and take log() of viscosity
end <- which(viscosity$timeAll == as.numeric(interval))
viscosity$vis <- log(viscosity$visAll[,1:end])
viscosity$time <- viscosity$timeAll[1:end]
# with(viscosity, funplot(time, vis, pch = 16, cex = 0.2))

## isotropic penalty, as timeformula is kroneckered to each effect using \%O\% 
## only for the smooth intercept \%A0\% is used, as 1-direction should not be penalized 
mod1 <- FDboost(vis ~ 1 + 
                bolsc(T_C, df = 1) + 
                bolsc(T_A, df = 1) + 
                bols(T_C, df = 1) \%Xc\% bols(T_A, df = 1),
                timeformula = ~ bbs(time, df = 3),
                numInt = "equal", family = QuantReg(),
                offset = NULL, offset_control = o_control(k_min = 9),
                data = viscosity, control=boost_control(mstop = 100, nu = 0.4))
## cf. the formula that is passed to mboost
mod1$formulaMboost

## anisotropic effects using \%A0\%, as lambda1 = 0 for all base-learners
## in this case using \%A\% gives the same model, but three lambdas are computed explicitly 
mod1a <- FDboost(vis ~ 1 + 
                bolsc(T_C, df = 1) \%A0\% bbs(time, df = 3) + 
                bolsc(T_A, df = 1) \%A0\% bbs(time, df = 3) + 
                bols(T_C, df = 1) \%Xc\% bols(T_A, df = 1) \%A0\% bbs(time, df = 3),
                timeformula = ~ bbs(time, df = 3),
                numInt = "equal", family = QuantReg(),
                offset = NULL, offset_control = o_control(k_min = 9),
                data = viscosity, control=boost_control(mstop = 100, nu = 0.4)) 
## cf. the formula that is passed to mboost
mod1a$formulaMboost

## alternative model specification by using a 0-matrix as penalty 
## only works for bolsc() as in bols() one cannot specify K 
## -> model without interaction term 
K0 <- matrix(0, ncol = 2, nrow = 2)
mod1k0 <- FDboost(vis ~ 1 + 
                 bolsc(T_C, df = 1, K = K0) +
                 bolsc(T_A, df = 1, K = K0), 
                 timeformula = ~ bbs(time, df = 3), 
                 numInt = "equal", family = QuantReg(), 
                 offset = NULL, offset_control = o_control(k_min = 9), 
                 data = viscosity, control=boost_control(mstop = 100, nu = 0.4))
## cf. the formula that is passed to mboost
mod1k0$formulaMboost
                
## optimize mstop for mod1, mod1a and mod1k0
## ...
                
## compare estimated coefficients
\dontrun{
par(mfrow=c(4, 2))
plot(mod1, which = 1)
plot(mod1a, which = 1)
plot(mod1, which = 2)
plot(mod1a, which = 2)
plot(mod1, which = 3)
plot(mod1a, which = 3)
funplot(mod1$yind, predict(mod1, which=4))
funplot(mod1$yind, predict(mod1a, which=4))
}

}
\references{
Brockhaus, S., Scheipl, F., Hothorn, T. and Greven, S. (2015): 
The functional linear array model. Statistical Modelling, 15(3), 279-300. 

Currie, I.D., Durban, M. and Eilers P.H.C. (2006):  
Generalized linear array models with applications to multidimensional smoothing. 
Journal of the Royal Statistical Society, Series B-Statistical Methodology, 68(2), 259-280.
}
