\name{fuelSubset}
\alias{fuelSubset}
\docType{data}
\title{ Spectral data of fossil fuels}
\description{

For 129 laboratory samples of fossil fuels the heat value and the humidity were
determined together with two spectra.
One spectrum is ultraviolet-visible (UV-VIS), measured at 1335 wavelengths in
the range of 250.4 to 878.4 nanometer (nm), the other a near infrared  spectrum
(NIR) measured at 2307 wavelengths in the range of 800.4 to 2779.0 nm.
\code{fuelSubset} is a subset of the original dataset containing only 10\% of
the original measures of the spectra, resulting in 231 measures of the
NIR spectrum and 134 measures of the UVVIS spectrum.

}
\usage{data("fuelSubset")}
\format{
  A data list with 129 observations on the following 7 variables.
  \describe{
    \item{\code{heatan}}{heat value in mega joule (mJ)}
    \item{\code{h2o}}{humidity in percent}
    \item{\code{NIR}}{near infrared spectrum (NIR) }
    \item{\code{UVVIS}}{ultraviolet-visible spectrum (UV-VIS)}
    \item{\code{nir.lambda}}{wavelength of NIR spectrum in nm}
    \item{\code{uvvis.lambda}}{wavelength of UV-VIS spectrum in nm}
    \item{\code{h2o.fit}}{predicted values of humidity}
  }
}
\details{
The aim is to predict the heat value using the spectral data. The variable
\code{h2o.fit} was generated by a functional linear regression model, using
both spectra and their derivatives as predictors.
}
\source{

   Siemens AG

   Fuchs, K., Scheipl, F. & Greven, S. (2013), Penalized scalar-on-functions
   regression with interaction term. Submitted for publication.

}
\examples{

    data("fuelSubset", package = "FDboost")

    ### fit mean regression model with 100 boosting iterations,
    ### step-length 0.1 and
    mod <- FDboost(heatan ~ bsignal(UVVIS, uvvis.lambda, knots=40, df=4, check.ident=FALSE)
                   + bsignal(NIR, nir.lambda, knots=40, df=4, check.ident=FALSE),
                   timeformula=~bols(1), data=fuelSubset)
    summary(mod)
    ## plot(mod)
}
\keyword{datasets}