% Generated by roxygen2 (4.0.1): do not edit by hand
\name{scaleUnit}
\alias{scaleUnit}
\title{A function to standardize the unit}
\usage{
scaleUnit(df, multiplier)
}
\arguments{
\item{df}{The data frame containing the data to be scale}

\item{multiplier}{The named vector with the multiplier to be
scaled. The name is mandatory in order for the function to identify
the variable in the data frame. A data.frame can also be supplied
with the first column being the name and the second being the
numeric multiplier.}
}
\description{
The function standardize the data to the desirable unit when the
multiplier vector is supplied. For example per 1000 people is
scaled to per person by supplying a multiplier of 1000.
}
\examples{
## Create the data frame
test.df = data.frame(FAOST_CODE = 1:5, Year = 1995:1999,
  var1 = 1:5, var2 = 5:1)

## Create the named vector for scaling
multiplier = c(1, 10)
names(multiplier) = c("var1", "var2")

## Scale the data
scaleUnit(test.df, multiplier = multiplier)
}

