% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_ext_obs_table.R
\name{prepare_ext_obs_table}
\alias{prepare_ext_obs_table}
\title{Prepares a Table Displaying Extreme Observations}
\usage{
prepare_ext_obs_table(df, n = 5, cs_id = NA, ts_id = NA,
  var = utils::tail(colnames(df[sapply(df, is.numeric) & (!colnames(df) \%in\%
  c(cs_id, ts_id))]), n = 1), ...)
}
\arguments{
\item{df}{Data frame}

\item{n}{The number of top/bottom observations that you want to report.}

\item{cs_id}{The variable(s) identifying the cross-section in the data.}

\item{ts_id}{The variable identifying the time-series in the data.}

\item{var}{Variable to display. Defaults to the last numerical variable of the data frame.}

\item{...}{Additional parameters that are passed to \code{\link[knitr]{kable}}.}
}
\value{
A list containing two items:
\describe{
 \item{"df"}{A data frame containing the top/bottom n observations}
 \item{"kable_ret"}{The return value provided by \code{\link[knitr]{kable}} containing the formatted table}
}
}
\description{
Reads a data frame, sorts it by the given variable and displays the top and bottom n observations.
}
\details{
When both \code{cs_id} and \code{ts_id} are omitted, all variables are tabulated.
  Otherwise, \code{var} is tabulated along with the identifiers.
  Infinite values in \code{var} are omitted.
  The default parameters for calling \code{\link[knitr]{kable}},
  are \code{format = "html", digits = 3, format.args = list(big.mark = ','), row.names = FALSE}.
}
\examples{
t <- prepare_ext_obs_table(russell_3000, n = 10,
                           cs_id = c("coid", "coname"),
                           ts_id = "period", var = "sales")
t$df
}
