% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lai.R
\name{lai}
\alias{lai}
\title{Leaf Area Index (LAI)}
\usage{
lai(GEN, W, L, TNL, TDL, crop = "soy", sp = 0.45, sden = 14, verbose = TRUE)
}
\arguments{
\item{GEN}{The column with the genotype name}

\item{W}{The column with the width of the leaf (in meters).}

\item{L}{The column with the length of the leaf (in meters).}

\item{TNL}{The column with the total number of leaves.}

\item{TDL}{The column with the total number of dry leaves.}

\item{crop}{Crop sampled. Use 'soy' for soybean and 'maize' for maize, 'trit'
for wheat, 'rice' for rice, 'bean' for bean, 'sunflower' for sunflower,
'cotton' for cotton, 'sugarcane' for sugarcane, 'potato' for potato and
'tomato' for tomato.}

\item{sp}{Row spacing (Standard sp=0.45).}

\item{sden}{Sowing density, in plants per linear meter (standard sden=14).}

\item{verbose}{Logical argument. Runs the code silently if FALSE.}
}
\value{
Returns the accumulated leaf area, the potential leaf area index
(considering the total number of leaves) and the actual leaf area index
(making the adjustment considering the number of dry leaves) for each genotype
}
\description{
Utility function for estimating crop LAI
}
\examples{
library(EstimateBreed)

data("leafarea")
#Crop selection
soy_lai<-with(leafarea,lai(GEN,C,L,TNL,TDL,crop="soy"))

#Changing row spacing and sowing density
maize_lai<-with(leafarea,lai(GEN,C,L,TNL,TDL,crop="maize",sp=0.45,sden=4))
}
\references{
Meira, D., Queiroz de Souza, V., Carvalho, I. R., Nardino, M., Follmann,
D. N., Meier, C., Brezolin, P., Ferrari, M., & Pelegrin, A. J. (2015).
Plastocrono e caracteres morfologicos da soja com habito de crescimento
indeterminado. Revista Cultivando o Saber, 8(2), 184-200.
}
\author{
Willyan Junior Adorian Bandeira

Ivan Ricardo Carvalho

Murilo Vieira Loro

Leonardo Cesar Pradebon

Jose Antonio Gonzalez da Silva
}
