% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_spec.R
\name{sd}
\alias{sd}
\alias{sd.dist_spec}
\title{Returns the standard deviation of one or more delay distribution}
\usage{
\method{sd}{dist_spec}(x, ...)
}
\arguments{
\item{x}{The <dist_spec> to use}
}
\value{
A vector of standard deviations.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
This works out the standard deviation of all the (parametric /
nonparametric) delay distributions combined in the passed <dist_spec>.
If any of the parameters are themselves uncertain then \code{NA} is returned.
}
\examples{
\dontrun{
# A fixed lognormal distribution with sd 5 and sd 1.
dist1 <- LogNormal(mean = 5, sd = 1, max = 20)
sd(dist1)

# A gamma distribution with mean 3 and sd 2
dist2 <- Gamma(mean = 3, sd = 2)
sd(dist2)

# The sd of the sum of two distributions
sd(dist1 + dist2)
}
}
\keyword{internal}
