% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create_shifted_cases}
\alias{create_shifted_cases}
\title{Create Delay Shifted Cases}
\usage{
create_shifted_cases(data, shift, smoothing_window, horizon)
}
\arguments{
\item{data}{A \verb{<data.frame>} of confirmed cases (confirm) by date
(date). \code{confirm} must be numeric and \code{date} must be in date format.}

\item{shift}{Numeric, mean delay shift to apply.}

\item{smoothing_window}{Numeric, the rolling average smoothing window
to apply. Must be odd in order to be defined as a centred average.}

\item{horizon}{Numeric, defaults to 7. Number of days into the future to
forecast.}
}
\value{
A \verb{<data.frame>} for shifted reported cases
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This functions creates a data frame of reported cases that has been smoothed
using a centred partial rolling average (with a period set by
\code{smoothing_window}) and shifted back in time by some delay. It is used by
\code{\link[=estimate_infections]{estimate_infections()}} to generate the mean shifted prior on which the back
calculation method (see \code{\link[=backcalc_opts]{backcalc_opts()}}) is based.
}
\details{
The function first shifts all the data back in time by \code{shift} days (thus
discarding the first \code{shift} days of data) and then applies a centred
rolling mean of length \code{smoothing_window} to the shifted data except for
the final period. The final period (the forecast horizon plus half the
smoothing window) is instead replaced by a log-linear model fit (with 1
added to the data for fitting to avoid zeroes and later subtracted again),
projected to the end of the forecast horizon. The initial part of the data
(corresponding to the length of the smoothing window) is then removed, and
any non-integer resulting values rounded up.
}
\examples{
\dontrun{
shift <- 7
horizon <- 7
smoothing_window <- 14
## add NAs for horizon
cases <- create_clean_reported_cases(example_confirmed, horizon = horizon)
## add zeroes initially
cases <- data.table::rbindlist(list(
   data.table::data.table(
     date = seq(
       min(cases$date) - smoothing_window,
       min(cases$date) - 1,
       by = "days"
     ),
     confirm = 0, breakpoint = 0
   ),
   cases
 ))
create_shifted_cases(cases, shift, smoothing_window, horizon)
}
}
\keyword{internal}
