% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kija_discrete_covariate_names.R
\name{DiscreteCovariateNames}
\alias{DiscreteCovariateNames}
\title{Extract discrete covariate names}
\usage{
DiscreteCovariateNames(covariates, discrete_covariates = NULL)
}
\arguments{
\item{covariates}{character, names of covariates}

\item{discrete_covariates}{character, names of discrete covariates. Currently
it is assumed that discrete covariates are one-hot encoded with naming in
covariates following \verb{\{fct_nm\}_\{lvl_nm\}}.}
}
\value{
A character vector with elements from covariates matching the names
supplied in discrete_covariates.
}
\description{
Detect elements in covariates which match a string from the discrete_covariates
argument.
}
\examples{
one_hot_df <- mtcars |>
  dplyr::mutate(across(c(2, 8:11), factor)) |>
  as.data.frame() |>
  DiscreteCovariatesToOneHot(cyl)
EpiForsk:::DiscreteCovariateNames(colnames(one_hot_df), c("cyl"))
}
\author{
KIJA
}
