% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineSource.R
\name{lineSource}
\alias{lineSource}
\title{Distribution of emissions by streets}
\source{
OpenstreetMap data avaliable \url{https://www.openstreetmap.org/}
}
\usage{
lineSource(s, grid, as_raster = F, verbose = T)
}
\arguments{
\item{s}{SpatialLinesDataFrame of SpatialLines object}

\item{grid}{grid object with the grid information}

\item{as_raster}{output format, TRUE for raster, FALSE for matrix}

\item{verbose}{display additional information}
}
\description{
Create a distribution from sp spatial lines data frame or spatial lines
}
\examples{
\donttest{
roads <- osmar::get_osm(osmar::complete_file(),
                        source = osmar::osmsource_file(paste(system.file("extdata",
                        package="EmissV"),"/streets.osm.xz",sep="")))
roads <- osmar::as_sp(roads,what = "lines")

d3    <- gridInfo(paste0(system.file("extdata", package = "EmissV"),"/wrfinput_d03"))

roadLength <- lineSource(roads,d3,as_raster=TRUE)
sp::spplot(roadLength, scales = list(draw=TRUE), ylab="Lat", xlab="Lon",main="Length of roads",
           sp.layout=list("sp.lines", roads))
}

}
\seealso{
\code{\link{gridInfo}} and \code{\link{rasterSource}}
}
