% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initF.R
\name{initF}
\alias{initF}
\title{Initialize threads and split data}
\usage{
initF(data, num = 2)
}
\arguments{
\item{data}{a numeric matrix stores data. Colunms as variables.}

\item{num}{an integer specifies number of threads to initialize.}
}
\value{
an S4 object of class "emcdf_obj", holding pointer to an C++ object. When passed to function emcdf(),
it computes joint CDF with multi-threads.
}
\description{
This function initializes threads and splits data. Retures an S4 object of class "emcdf_obj" that is ready for parallel computation.
}
\details{
The input data must be a numeric matrix with variables as columns. The choice of "num" is machine dependent.
A reasonable number would be the total number of CPU cores - 1. Call coreNum() to get CPU core number.
}
\examples{
n = 10^5
set.seed(123)
x = rnorm(n)
y = rnorm(n)
z = rnorm(n)
data = cbind(x, y, z)

#decide thread number
num = coreNum() - 1

#initialize threads
obj = initF(data, num)

#compute empirical CDF
emcdf(obj, c(0.5, 0.5, 0.5))

}

