% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stab_elo.R
\name{stab_elo}
\alias{stab_elo}
\alias{stab.elo}
\title{stability index \emph{S}}
\usage{
stab_elo(eloobject, from = min(eloobject$stability$date),
  to = max(eloobject$stability$date), weight = TRUE)
}
\arguments{
\item{eloobject}{an object of class \code{"elo"}, usually the result of a call to \code{\link{elo.seq}}}

\item{from}{character, from which date onwards should \emph{S} be calculated. By default the first date in the sequence is used}

\item{to}{character, until which date should \emph{S} be calculated. By default the last date in the sequence is used}

\item{weight}{logical, should single rank changes be weighted by the Elo rating of the highest-rated individual involved in a rank change? Default is \code{TRUE}}
}
\value{
returns the \emph{S} index
}
\description{
calculates the \emph{S} index as metric for the overall stability of a hierarchy during a specified time period
}
\details{
\emph{S} ranges between 0 and 1, where 0 indicates an unstable hierarchy, in which the ordering reverses every other day, and 1, in which the ordering is stable and no rank changes occur.

In contrast to the originally proposed \emph{S}, this version is now standardized between 0 and 1, and additionally, the interpretation is reversed, i.e. 1 refers to stable situations, whereas values closer to 0 indicate more instable hierarchies
}
\examples{
data(adv)
SEQ <- elo.seq(winner=adv$winner, loser=adv$loser, Date=adv$Date)
stab_elo(SEQ)
stab_elo(SEQ, weight=FALSE)
stab_elo(SEQ, from="2010-01-20", to="2010-01-30")
stab_elo(SEQ, from="2010-01-20", to="2010-01-30", weight=FALSE)
}
\references{
\insertRef{neumann2011}{EloRating}

\insertRef{mcdonald2013a}{EloRating}
}
\author{
Christof Neumann
}
