% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbind.light.edsurvey.data.frame.R,
%   R/rbind.light.edsurvey.data.frame.R
\name{cbind}
\alias{cbind}
\alias{rbind}
\title{Combine R Objects by Rows or Columns}
\usage{
cbind(..., deparse.level = 1)

rbind(..., deparse.level = 1)
}
\arguments{
\item{...}{one or more objects of class \code{vector}, \code{data.frame}, \code{matrix}, or \code{light.edsurvey.data.frame}}

\item{deparse.level}{integer determining under which circumstances column and row names are built from the actual arguments. See \ifelse{latex}{\code{cbind}}{\code{\link[base:cbind]{cbind}}}.}
}
\value{
a matrix-like object like \code{matrix} or \code{data.frame}. Returns a \code{light.edsurvey.data.frame} if there is 
         at least one \code{light.edsurvey.data.frame} in the list of arguments.
}
\description{
Implements \code{\link{cbind}} and \code{\link{rbind}} for \code{light.edsurvey.data.frame} class.
             It takes a sequence of \code{vector}, \code{matrix}, \code{data.frame}, or \code{light.edsurvey.data.frame} arguments and combines
             by columns or rows, respectively.
}
\details{
Because \code{cbind} and \code{rbind} are standard generic functions that do not use method dispatch, we set this function as generic,
         which means it overwrites \code{base::cbind} and \code{base::rbind} on loading. If none of the specified elements are of class \code{light.edsurvey.data.frame}, 
         the function will revert to the standard \code{base} method. However, to be safe, you might want to explicitly use \code{base::cbind} when needed after loading the package.
         
         The returned object will contain attributes only from the first \code{light.edsurvey.data.frame} object in the call to
         \code{cbind.light.edsurvey.data.frame}.
}
\seealso{
\ifelse{latex}{\code{cbind}}{\code{\link[base:cbind]{cbind}}}
}
\author{
Trang Nguyen, Michael Lee, and Paul Bailey
}
