% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPlausibleValue.R
\name{getPlausibleValue}
\alias{getPlausibleValue}
\title{Get plausible values from a given subject or subscale.}
\usage{
getPlausibleValue(var, data)
}
\arguments{
\item{var}{a character vector naming the subject scale or subscale.}

\item{data}{an \code{edsurvey.data.frame} or \code{light.edsurvey.data.frame}.}
}
\value{
A character vector of the set of variable names for the plausible values.
}
\description{
Get the set of variables on an \code{edsurvey.data.frame} or \code{light.edsurvey.data.frame} associated with the given subject or subscale.
}
\details{
This function will return a set of variable names for plausible values that
\code{\link{hasPlausibleValue}} returns as true.
}
\examples{
# read in the example data (generated, not real student data)
sdf <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package = "NAEPprimer"))

getPlausibleValue(var="composite", data=sdf)
}
\seealso{
\code{\link{showPlausibleValues}}
}
\author{
Michael Lee and Paul Bailey
}
