% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{reorderTerms}
\alias{reorderTerms}
\alias{pvalOrder}
\alias{bselOrder}
\alias{fselOrder}
\alias{revPredOrd}
\alias{randomPredOrder}
\alias{regsubsetsOrder}
\title{Re-order model terms}
\usage{
pvalOrder(m, d = NULL, refit = TRUE)

bselOrder(m, d = NULL, refit = TRUE, maxNPred = NULL)

fselOrder(m, d = NULL, refit = TRUE, maxNPred = NULL)

revPredOrd(m, d = NULL, refit = TRUE)

randomPredOrder(m, d = NULL, refit = TRUE)

regsubsetsOrder(m, d = NULL, refit = TRUE, collapse = TRUE)
}
\arguments{
\item{m}{an lm objecct}

\item{d}{the data frame. If NULL, attempts to extract from m.}

\item{refit}{TRUE or FALSE}

\item{maxNPred}{maximum number of predictors to use, defaults to all.}

\item{collapse}{TRUE or FALSE}
}
\value{
a vector of terms in order last to first, or an lm if refit=TRUE. regsubsetsOrder returns a list of predictor vectors, or a list of fits
}
\description{
Re-order model terms
}
\section{Functions}{
\itemize{
\item \code{pvalOrder}: Arranges model terms in order of increasing p-value

\item \code{bselOrder}: Arranges model terms using backwards selection

\item \code{fselOrder}: Forwards selection

\item \code{revPredOrd}: Reverses order of terms in a fit

\item \code{randomPredOrder}: Reorders terms in a fit randomly

\item \code{regsubsetsOrder}: Best subsets regression.
}}

\examples{
bselOrder(lm(mpg~wt+hp+disp, data=mtcars))
fselOrder(lm(mpg~wt+hp+disp, data=mtcars))
revPredOrd(lm(mpg~wt+hp+disp, data=mtcars))
randomPredOrder(lm(mpg~wt+hp+disp, data=mtcars))
regsubsetsOrder(lm(mpg~wt+hp+disp, data=mtcars))
}
