% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/casedat.R
\docType{data}
\name{casedat}
\alias{casedat}
\title{casedat}
\format{This data is from Walker and Kadlec, "A Model for Simulating Phosphorus Concentrations in Waters & Soils Downstream of Everglades Stormwater Treatment Areas", prepared for US Dept of the Interior,  August 1996.
\itemize{
\item{\code{case.number}}{ Index value unique for each case}
\item{\code{STA.Name}}{ The name of the Stormwater Treatment Area (STA) where this data originated.}
\item{\code{Receiving.Area}}{ The area which this STA discharges.}
\item{\code{Start.Discharge}}{ The year which this particular STA began discharge operations.}
\item{\code{STA.outflow.TPconc}}{ Outflow total phosphorus concentration (in ug L-1; mirograms per liter) for this STA.}
\item{\code{STA.outflow.vol}}{ Annual outflow discharge volume (in x1000 Acre-Feet Year-1) for this STA.}
\item{\code{FlowPath.width}}{ The width of the downstream flow path (in kilometers).}
\item{\code{Hydroperiod}}{ Average hydroperiod (time above ground surface) of the downstream system (in percent).}
\item{\code{Soil.Depth}}{ Depth of soil (in centimeters).}
\item{\code{Soil.BulkDensity.initial}}{ The initial bulk density prior to dicharge of the soil downstream of the system (in g cm-3).}
\item{\code{Soil.TPConc.initial}}{ The initial total phosphorus concentration of soil prior to discharge downstream of the system (in mg kg-1).}
\item{\code{Vertical.soilTPGradient.initial}}{ The soil total phosphorus concentration gradient prior to dischage downstream of the system (in mg cm-3 cm-1).}
\item{\code{Soil.BulkDensity.final}}{ The final bulk density after dischage of the soil downstream of the system (in g cm-3).}
\item{\code{PSettlingRate}}{ The phosphorus settling rate estimated from steady-state conditions (m Year-1).}
\item{\code{P.AtmoDep}}{ Phosphorus atmospheric depostition loading rate (in mg m-2 Year-1).}
\item{\code{Rainfall}}{ Annual accumulated rainfall estimate (m Year-1).}
\item{\verb{ET Annual}}{ evapotranspiration estimate (m Year-1).}
}}
\source{
\url{http://www.wwwalker.net/epgm/}
}
\usage{
casedat
}
\description{
Data
}
\keyword{dataset}
