% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EPGMTime.R
\name{EPGMTime}
\alias{EPGMTime}
\title{Time Profile}
\usage{
EPGMTime(
  case.no = NA,
  Start.Discharge = NA,
  STA.outflow.TPconc = NA,
  STA.outflow.vol = NA,
  FlowPath.width = NA,
  Hydroperiod = NA,
  Soil.Depth = NA,
  Soil.BulkDensity.initial = NA,
  Soil.TPConc.initial = NA,
  Vertical.SoilTPGradient.initial = NA,
  Soil.BulkDensity.final = NA,
  PSettlingRate = NA,
  P.AtmoDep = NA,
  Rainfall = NA,
  ET = NA,
  Dist.Display = 12,
  Dist.slice = c(0, 0.5, 1, 2, 5, 10),
  Max.Yrs = 200,
  Max.Dist = 15,
  Time.increment.yr = 5,
  Dist.increment.km = 0.1,
  plot.profile = TRUE,
  raw.time.output = FALSE,
  results.time.table = TRUE
)
}
\arguments{
\item{case.no}{Case number from the pre-loaded example data (values ranges from 1 to 12)}

\item{Start.Discharge}{The year which this particular STA began discharge operations.}

\item{STA.outflow.TPconc}{Outflow total phosphorus concentration (in ug L-1; micrograms per liter) for this STA.}

\item{STA.outflow.vol}{Annual outflow discharge volume (in x1000 Acre-Feet Year-1) for this STA.}

\item{FlowPath.width}{The width of the downstream flow path (in kilometers).}

\item{Hydroperiod}{Average hydroperiod (time above ground surface) of the downstream system (in percent).}

\item{Soil.Depth}{Depth of soil (in centimeters).}

\item{Soil.BulkDensity.initial}{The initial bulk density prior to dicharge of the soil downstream of the system (in g cm-3).}

\item{Soil.TPConc.initial}{The initial total phosphorus concentration of soil prior to discharge downstream of the system (in mg kg-1).}

\item{Vertical.SoilTPGradient.initial}{The soil total phosphorus concentration gradient prior to dischage downstream of the system (in mg cm-3 cm-1).}

\item{Soil.BulkDensity.final}{The final bulk density after dischage of the soil downstream of the system (in g cm-3).}

\item{PSettlingRate}{The phosphorus settling rate estimated from steady-state conditions (m Year-1).}

\item{P.AtmoDep}{Phosphorus atmospheric depostition loading rate (in mg m-2 Year-1).}

\item{Rainfall}{Annual accumulated rainfall estimate (m Year-1).}

\item{ET}{Annual evapotranspiration estimate (m Year-1).}

\item{Dist.Display}{Output display result for this distance}

\item{Dist.slice}{A list of distances to disply parameters in a time series plot if \code{plot.profile} is \code{TRUE}.}

\item{Max.Yrs}{Maximum number of years simulated}

\item{Max.Dist}{Maximum ditance plotted, default is 50 km}

\item{Time.increment.yr}{Year increment to be modeled}

\item{Dist.increment.km}{Distance increment modeled}

\item{plot.profile}{If \code{TRUE} base plot will be generate with water column distance, soil distance and cattail distance profiles.}

\item{raw.time.output}{If \code{TRUE} a \code{data.frame} will be printed with all calculations used to estimate various parameters.Default is set to \code{FALSE}.}

\item{results.time.table}{If \code{TRUE} a summary results table will be printed in the console. Default is set to \code{TRUE}.}
}
\value{
This function computes and plots the distance profile along the gradient based on input values
}
\description{
This function runs the EPGM model over a simulated period. The model is based primarily upon data collected in the early 1990's along the phosphorus gradient in WCA-2A. Substantial additional data collected since then in WCA-2A and other locations indicate a need to recalibrate the model and potentially revise its structure. Recent data suggest, for example, that the relationship between cattail density and soil P needs recalibration and that actual soil P thresholds for biological impacts are probably lower than reflected in the original calibrations.  There are also issues relating to interpretation of and potential anomalies in the historical soil P calibration data attributed to variations in soil core collection method and definition of the soil/water interface (inclusion vs. exclusion of floc layer). There are also indications in the recent data of biologically-mediated vertical transport and/or mixing that are not reflected in the current model structure.
}
\details{
As described in the original documentation, the model is designed to simulate marsh enrichment (responses to increasing P load), not recovery (responses to decreasing in load).
}
\examples{
EPGMTime(case.no=11)
}
\keyword{"water}
\keyword{quality"}
