% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EPGMThreshold.R
\name{EPGMThreshold}
\alias{EPGMThreshold}
\title{Threshold Evaluation}
\usage{
EPGMThreshold(
  time.dat,
  WaterColumn.Thresholds = c(10, 15, 20),
  Soil.Thresholds = c(500, 600, 1000),
  cattail.Thresholds = c(5, 20, 90),
  plot.exceed = TRUE,
  raw.area.output = FALSE,
  results.area.table = TRUE
)
}
\arguments{
\item{time.dat}{a \code{data.frame}, the raw output from EPGMTime (when \code{raw.time.output=TRUE}).}

\item{WaterColumn.Thresholds}{a list of three water column total phosphorus thresholds to evaluate time output.}

\item{Soil.Thresholds}{a list of three soil total phosphorus thresholds to evaluate time output.}

\item{cattail.Thresholds}{a list of three cattail density thresholds to evaluate time output.}

\item{plot.exceed}{If \code{TRUE} base plot will be generate with water column, soil and cattail area exceeded plots.}

\item{raw.area.output}{If \code{TRUE} a \code{data.frame} will be printed with all area exceedances calculated for each time step.Default is set to \code{FALSE}.}

\item{results.area.table}{If \code{TRUE} a summary results table will be printed in the console. Default is set to \code{TRUE}.}
}
\value{
This function computes and plots the distance profile along the gradient based on input values
}
\description{
This function evaluates results of the EPGM model over a simulated period relative to ecological or regulatory thresholds.
}
\details{
As described in the original documentation, the model is designed to simulate marsh enrichment (responses to increasing P load), not recovery (responses to decreasing in load).
}
\examples{
example<-EPGMTime(case.no=11,raw.time.output=TRUE)
EPGMThreshold(example)

#END
}
\keyword{"water}
\keyword{quality"}
