% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multistack.pca.R
\name{multistack.pca}
\alias{multistack.pca}
\title{multistack.pca, simultaneous PCA on more than one stack of environmental rasters}
\usage{
multistack.pca(..., n = 2)
}
\arguments{
\item{...}{Any number of environmental raster stacks or bricks}

\item{n}{The number of PCA layers to return}
}
\value{
A list containing a stack or brick of rasters for each input set representing the top n pca axes of the initial environmental variables, as well as the pca object from the analysis that produced them and some useful plots showing the distribution of each PC in the different stacks.
}
\description{
multistack.pca, simultaneous PCA on more than one stack of environmental rasters
}
\examples{
test1 <- crop(euro.worldclim, extent(-10, -5, 40, 43))
test2 <- crop(euro.worldclim, extent(-5, 5, 40, 48))
test3 <- crop(euro.worldclim, extent(5, 15, 44, 48))
multistack.pca(test1, test2, test3)
}
\keyword{environment}
\keyword{pca}
\keyword{raster}
