% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMSC_results.R
\name{predict.EMSC}
\alias{predict.EMSC}
\title{Predict Method for EMSC}
\usage{
\method{predict}{EMSC}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{An object fitted by the \code{EMSC} function.}

\item{newdata}{A \code{matrix} or object convertable to a matrix containing observations as rows.}

\item{...}{unused.}
}
\description{
Prediction for \code{EMSC} ojects. Corrections are calculated for the new
\code{matrix} based on the EMSC model used in the input object.
}
\examples{
data(milk)
Raman.cal <- milk$Raman[  1:90,  850:3300]
Raman.val <- milk$Raman[-(1:90), 850:3300]
EMSC.cal  <- EMSC(Raman.cal)
EMSC.val  <- predict(EMSC.cal, Raman.val)
identical(EMSC.cal$model, EMSC.val$model) # Same model, reference spectrum, etc.

matplot(t(EMSC.cal$corrected), type = 'l', col = 'black', lty = 1, ylab = 'Intensity')
matplot(t(EMSC.val$corrected), type = 'l', col = 'red', lty = 2, add = TRUE)
legend('topleft', legend = c('Calibration','Validation'), lty = 1:2, col = 1:2)

}
\seealso{
\code{\link{EMSC}} \code{\link{EMSC_model}}
}

