% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_selection.R
\name{ELCIC.wgee.single}
\alias{ELCIC.wgee.single}
\title{Calculate ELCIC value for a given candidate model under WGEE framework for missing longitudinal data under the mechanism of missing at random and drop-out}
\usage{
ELCIC.wgee.single(x,y,x_mis,r,id,time,index.var=NULL,
      name.var=NULL,dist,corstr,joints=TRUE,lag=1)
}
\arguments{
\item{x}{A matrix containing covariates. The first column should be all ones corresponding to the intercept if the intercept is considered in the marginal mean. Covariate matrix should be complete. See more in details section.}

\item{y}{A vector containing outcomes. Use NA to indicate missing outcomes.}

\item{x_mis}{A matrix containing covariates for the missing data model. The first column should be all ones corresponding to the intercept. This covariate matrix should be complete and all observed. See more in details section.}

\item{r}{A vector indicating the observation of outcomes: 1 for observed records, and 0 for unobserved records.}

\item{id}{A vector indicating subject id.}

\item{time}{The number of observations in total for each subject}

\item{index.var}{A vector containing index corresponding to candidate covariates. See more in details section.}

\item{name.var}{A vector containing names of candidate covariates. The names should be subset of column names of x matrix. See more in details section.}

\item{dist}{A specified distribution. It can be "gaussian", "poisson",and "binomial".}

\item{corstr}{A candidate correlation structure. It can be "independence","exchangeable", and "ar1".}

\item{joints}{A logic value for joint selection of marginal mean and working correlation structure. The default is TRUE. See more in details section.}

\item{lag}{A numeric value indicating lag-response involved in the missing data model. It can be one of 0, 1, and 2. The default is 1.}
}
\value{
A matrix containing values of calculated estimating equations.
}
\description{
The function \code{\link{ELCIC.wgee.single}} to calculate ELCIC value for a given candidate mean model with specified working correlation structure. It is able to simultaneously evaluate mean model and working correlation structure. The data is dropout missing and missing at random.
}
\details{
Covariate matrix "x" should be complete. If missing data are present in "x", the elements in covariate vector will be replaced by zeros for individuals who have missing covariates.

The argument "x_mis" includes all covariates to fit the missing data model. It does not contains a lag variable based on the outcome y. The argument "lag" in this function will automatically add lag-response variables to indicate the data missing at random.

Either arguments "index.var" or "name.var" is used to identify the candidate mean model. If both arguments are provided, only the argument "name.var" will be used.

When the argument "joints" is TRUE, \code{\link{ELCIC.wgee.single}} will calculate ELCIC value based on the function \code{\link{lambda.find.wgee}} and \code{\link{ee.wgee}}, which involve estimating equations for both marginal mean and correlation coefficient. When the argument "joints" is FALSE, \code{\link{ELCIC.wgee.single}} will calculate ELCIC value based on the function \code{\link{lambda.find.wgee.mean}} and \code{\link{ee.wgee.mean}}, which only involve estimating equations for marginal mean.
}
\examples{
## tests
# load data
data(wgeesimdata)
corstr<-"exchangeable"
dist<-"binomial"
x<-wgeesimdata$x
y<-wgeesimdata$y
x_mis<-wgeesimdata$x_mis
r<-wgeesimdata$obs_ind
id<-wgeesimdata$id
time<-3
index.var<-c(1,2,3)
ELCIC_value<-ELCIC.wgee.single(x,y,x_mis,r,id,time,index.var,name.var=NULL,
                     dist,corstr,joints=TRUE)
ELCIC_value
}
