% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation_MM_kp.R
\name{MM_catal_est}
\alias{MM_catal_est}
\title{Simulataneous estimation of Michaelis-Menten constant and catalytic constant}
\usage{
MM_catal_est(method = T, time, species, enz, subs, MM, catal, tun = 2.4,
  std, nrepeat, jump = 1, burning = 0, catal_m = 1, catal_v = 10000,
  MM_m = 1, MM_v = 10000)
}
\arguments{
\item{method}{method selection: T=TQ model, F=SQ model(default = T)}

\item{time}{observed time interval}

\item{species}{observed trajectory of product}

\item{enz}{enzyme concentration}

\item{subs}{substrate concentration}

\item{MM}{true value of MM constant}

\item{catal}{initial value of catalytic constant}

\item{tun}{tunning constant of MH algorithm (default=2.4)}

\item{std}{standard deviation of proposal distribution (if =0, caclulated by Opt. function)}

\item{nrepeat}{total number of iteration (default=10000)}

\item{jump}{length of distance (default =1)}

\item{burning}{lenth of burning period (default =0)}

\item{catal_m}{prior mean of gamma prior (default =1)}

\item{catal_v}{prior variance of gamma prior (default =10000)}

\item{MM_m}{prior mean of gamma prior (default =1)}

\item{MM_v}{prior variance of gamma prior (default =10000)}
}
\value{
A n*2 matrix of postrior samples of catalytic constant and MM constant
}
\description{
The function estimates both catalytic and MM constant simultaneously with given
enzyme concentration and substrate concentration.
}
\details{
The function MM_catal_est generates a set of Markov Chain Monte Carlo
simulation samples from the posterior distribution of MM and catalytic
constant of enzyme kinetics model. Because the function considers both
MM constant and catalytic constant as parameters to be estimated, the user should
input constants of enzyme concentration, substrate concentration.
prior information for both two parameter can be given.
The turning constant and standard deviation can be set to controlled proper mixing
and acceptance ratio of MM constant from it's conditional posterior distribution.
Posterior samples are only stored with fixed interval according to set "jump"
to reduce serial correlation
The initial iterations are removed for convergence. The burning is set the length of
initial iterations.
}
\examples{
data("Chymo_low")
time1=Chymo_low[,1]
species1=Chymo_low[,2]
Chymotrypsin.low<-MM_catal_est(method=TRUE, time=time1,species=species1,enz=4.4e+7
,subs=4.4e+7,MM=1e+9,catal=0.01,tun=2.4,std=8e+7,nrepeat=1000,jump=10,
burning=0,catal_m=1,catal_v=1e+10, MM_m=1e+9,MM_v=1e+18)
}
