% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vn.entropy.R
\name{vn.entropy}
\alias{vn.entropy}
\title{Entropy Fit Index using Von Neumman's entropy (Quantum Information Theory) for correlation matrices}
\usage{
vn.entropy(data, structure)
}
\arguments{
\item{data}{A datafram or a correlation matrix}

\item{structure}{A vector representing the structure (numbers or labels for each item).
Can be theoretical factors or the structure detected by \code{\link{EGA}}}
}
\value{
Returns a list containing:

\item{VN.Entropy.Fit}{The Entropy Fit Index using Von Neumman's entropy}

\item{Total.Correlation}{The total correlation of the dataset}

\item{Average.Entropy}{The average entropy of the dataset}
}
\description{
Computes the fit of a dimensionality structure using Von Neumman's entropy when the input is a correlation matrix.
Lower values suggest better fit of a structure to the data.
}
\examples{
# Load data
dep <- depression[,24:44]

\donttest{# Estimate EGA
## plot.type = "qqraph" used for CRAN checks
## plot.type = "GGally" is the default
ega.dep <- EGA(data = dep, model = "glasso", plot.type = "qgraph")

# Compute entropy indices
vn.entropy(data = ega.dep$correlation, structure = ega.dep$wc)
}

}
\references{
Golino, H., Moulder, R. G., Shi, D., Christensen, A. P., Garrido, L. E., Neito, M. D., Nesselroade, J., Sadana, R., Thiyagarajan, J. A., & Boker, S. M. (2020).
Entropy fit indices: New fit measures for assessing the structure and dimensionality of multiple latent variables.
\emph{Multivariate Behavioral Research}.
\doi{10.31234/osf.io/mtka2}
}
\seealso{
\code{\link[EGAnet]{EGA}} to estimate the number of dimensions of an instrument using EGA and
\code{\link[EGAnet]{CFA}} to verify the fit of the structure suggested by EGA using confirmatory factor analysis.
}
\author{
Hudson Golino <hfg9s at virginia.edu>, Alexander P. Christensen <alexpaulchristensen@gmail.com>, and Robert Moulder <rgm4fd@virginia.edu>
}
