% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_packageid_reads.R
\name{get_packageid_reads}
\alias{get_packageid_reads}
\title{Get package ID reads}
\usage{
get_packageid_reads(packageId, as = "data.frame", env = "production")
}
\arguments{
\item{packageId}{(character) Data package identifier}

\item{as}{(character) Format of the returned object. Can be: "data.frame" 
or "xml".}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(data.frame or xml_document) Summary of all the successful reads 
(total reads and non-robot reads) of \code{packageId}
}
\description{
Get package ID reads
}
\examples{
\dontrun{

# Get packageId reads
resourceReads <- get_packageid_reads("knb-lter-sgs.817.17")
}
}
\seealso{
Other Audit Manager Services: 
\code{\link{get_audit_count}()},
\code{\link{get_audit_record}()},
\code{\link{get_audit_report}()},
\code{\link{get_docid_reads}()},
\code{\link{get_recent_uploads}()}
}
\concept{Audit Manager Services}
